<div class="testimonial-slider-container clearfix loading">
  <?php $carousel_transition = isset( $args['carousel_transition'] ) ? $args['carousel_transition'] : ''; ?>
    <div id="slider" class="testimonial-slider testimonial-carousel-fullwidth" data-autplay-transition="<?php echo $carousel_transition; ?>">
		<?php foreach ($args['posts'] as $testimonial) { ?>
			<?php if ( isset( $testimonial['testimonial'] ) ) { ?>
				<div class="item container1 content6 style-8 testimonial-id-<?php echo $testimonial['id']; ?>" itemscope itemtype="http://schema.org/Review">
					<div itemprop="itemReviewed" itemscope itemtype="http://schema.org/Organization">
						<meta itemprop="name" content="<?php bloginfo( 'name' ); ?>" />
						<meta itemprop="url" content="<?php bloginfo( 'url' ); ?>" />
					</div>
					<?php if ( isset( $testimonial['title'] ) && $args['show_title'] == 1 ) { ?>
						<h4 itemprop="name"><?php echo $testimonial['title']; ?></h4>
					<?php } ?>
					<div class="container1-right">

						<?php if ( !empty( $args['show_image'] ) ) { ?>
							<?php if ( isset( $testimonial['image'] ) ) { ?>
								<img src="<?php echo $testimonial['image']; ?>" style="border-radius: 50%;" alt="">
							<?php } ?>
						<?php } ?>

						<div class="author_wrap" itemprop="author" itemscope itemtype="http://schema.org/Person">

						<?php if ( !empty( $testimonial['name'] ) ) { ?>
							<div class="author-name" itemprop="name"><?php echo $testimonial['name']; ?></div>
						<?php } ?>
						<?php if ( !empty( $testimonial['position'] ) && !empty( $args['show_position'] ) ) { ?>
							<?php if ( !empty( $testimonial['link'] ) ) { ?>
								<div class="author-work" itemprop="jobTitle"><a href="<?php echo $testimonial['link']; ?>" itemprop="url" target="_blank" rel="nofollow"><?php echo $testimonial['position']; ?></a></div>
							<?php } else { ?>
								<div class="author-work" itemprop="jobTitle"><?php echo $testimonial['position']; ?></div>
							<?php } ?>
						<?php } ?>

						</div>
						<?php if ( !empty( $args['show_rating'] ) && !empty( $testimonial['rating'] ) ) { ?>
							<div class="rating" itemprop="reviewRating" itemscope itemtype="http://schema.org/Rating">
								<span class="value-title" title="<?php echo $testimonial['rating']; ?>"></span>
								<?php echo mts_testimonials_get_rating_html( $testimonial['rating'] ); ?>
								<meta itemprop="ratingValue" content="<?php echo $testimonial['rating']; ?>" />
							</div>
						<?php } ?>
					</div>
					<p class="quotes" itemprop="reviewBody"><?php echo $testimonial['testimonial']; ?></p>
				</div>
			<?php } ?>
		<?php } ?>
	</div>
	<!-- /testimonial-slider -->
</div>
<!-- /testimonial-slider-container -->
